#!/usr/bin/env python3
"""
Figure 1: ECDF comparisons for hominin stability metrics
"""

import pandas as pd
import matplotlib.pyplot as plt

# ============================================================
# FILES
# ============================================================

FILES = [
    ("Stability gradient",
     "ecdf_homo_stability_gradient.csv",
     "ecdf_civilization_stability_gradient.csv",
     "stability_gradient"),

    ("Mean distance to zero contour (deg)",
     "ecdf_homo_mean_zero_contour_distance_deg.csv",
     "ecdf_civilization_mean_zero_contour_distance_deg.csv",
     "mean_zero_contour_distance"),

    ("Variance of zero-contour distance (deg²)",
     "ecdf_homo_var_zero_contour_distance_deg2.csv",
     "ecdf_civilization_var_zero_contour_distance_deg2.csv",
     "var_zero_contour_distance")
]

# ============================================================
# PLOT
# ============================================================

fig, axes = plt.subplots(1, 3, figsize=(15, 4), sharey=True)

for ax, (title, homo_file, civ_file, colname) in zip(axes, FILES):
    homo = pd.read_csv(homo_file)
    civ  = pd.read_csv(civ_file)

    ax.plot(homo[f"homo_x"], homo["homo_ecdf"],
            label="Early Homo", linewidth=2)

    ax.plot(civ[f"civilization_x"], civ["civilization_ecdf"],
            label="Early Civilizations", linewidth=2)

    ax.set_title(title)
    ax.set_xlabel(colname)
    ax.grid(alpha=0.3)

axes[0].set_ylabel("ECDF")
axes[0].legend(frameon=False)

plt.suptitle("Distributional comparison of hominin stability metrics",
             fontsize=13)

plt.tight_layout()
plt.savefig("figure_ecdf_hominin_stability.png",
            dpi=300, bbox_inches="tight")
plt.close()
