#!/usr/bin/env python3
"""
Figure 3: Permutation test result (observed vs random)
"""

import pandas as pd
import matplotlib.pyplot as plt

# ============================================================
# LOAD RESULTS
# ============================================================

perm = pd.read_csv("permutation_test_results.csv")

# ============================================================
# PLOT
# ============================================================

fig, ax = plt.subplots(figsize=(6, 4))

ax.scatter(
    perm["group"],
    perm["observed_median_gradient"],
    s=80,
    zorder=3
)

for i, row in perm.iterrows():
    ax.text(
        i,
        row["observed_median_gradient"],
        f"p = {row['permutation_p_value']:.3g}",
        ha="center",
        va="bottom"
    )

ax.set_ylabel("Observed median stability gradient")
ax.set_title("Observed stability vs random land occupation")
ax.grid(alpha=0.3)

plt.tight_layout()
plt.savefig("figure_permutation_test.png",
            dpi=300, bbox_inches="tight")
plt.close()
