#!/usr/bin/env python3
"""
Figure 2: Summary distributions (box + violin)
"""

import pandas as pd
import matplotlib.pyplot as plt

# ============================================================
# LOAD DATA
# ============================================================

homo = pd.read_csv("homo_site_metrics.csv")
civ  = pd.read_csv("civilization_site_metrics.csv")

metrics = [
    ("stability_gradient", "Stability gradient"),
    ("mean_zero_contour_distance_deg", "Mean zero-contour distance (deg)"),
    ("var_zero_contour_distance_deg2", "Variance of distance (deg²)")
]

# ============================================================
# PLOT
# ============================================================

fig, axes = plt.subplots(1, 3, figsize=(15, 4))

for ax, (col, label) in zip(axes, metrics):
    data = [homo[col].dropna(), civ[col].dropna()]

    ax.violinplot(data, showextrema=False)
    ax.boxplot(data, widths=0.15)

    ax.set_xticks([1, 2])
    ax.set_xticklabels(["Early Homo", "Civilizations"])
    ax.set_title(label)
    ax.grid(alpha=0.3)

plt.suptitle("Summary comparison of hominin stability metrics",
             fontsize=13)

plt.tight_layout()
plt.savefig("figure_violin_hominin_stability.png",
            dpi=300, bbox_inches="tight")
plt.close()
